package UI;

import Back.Node;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

import java.io.Serializable;


public class GraphicNode<T extends Serializable & Comparable<T>> extends Pane {
        private Node<T> node;
        private double x, y, r, stroke;
         /**
         * konstruktor grafickej reprezentacie Ostatne.Node
         * @param n Ostatne.Node ktoru reprezentuje
          * @param _x suradnica x
          * @param _y suradnica y
          * @param _r dlzka steny
          * @param _sr sirka obvodu
          */
        public GraphicNode(Node n, double _x, double _y, double _r, int _sr){
            node = n;
            x = _x;
            y = _y;
            r = _r;
            stroke = _sr;

        }
    /**
     @return vrati Ostatne.Node
     */
        public Node getNode() {
            return node;
        }

    /**
     vykresli stvorec podla ulozenych parametrov
     vyfarbi ho nasledovne:
        - normalne je na bielo s ciernym okrajom
        - ak je vo find vyfarbi ho na kremovo
        - ak je v add vyfarbi ho na zlato
        - ak je vo find a add zaroven vyfarbi ho na zlato s cervenym okrajom
     */
        public void paint(){
            getChildren().clear();

            Rectangle e = new Rectangle(x,y, r, r);
            Text t = new Text(x+r*0.4, y+r*0.6, (String) node.getValue());

            e.setFill(Color.WHITE);
            e.setStroke(Color.BLACK);
            e.setStrokeWidth(stroke);

            if (node.getFind()) {
                e.setFill(Color.BLANCHEDALMOND);
            }

            if (node.getAdd()) {
                e.setFill(Color.GOLD);
            }

            if ( node.getFind() && node.getAdd() ){
                e.setStroke(Color.RED);
            }

            getChildren().add(e);
            getChildren().add(t);
        }

    }

